/**
* \file: AditNavigationStatus.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: K. Kuroda / ADITJ/SW / kkuroda@jp.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/
#ifndef AAUTO_ADITNAVIGATIONSTATUS_H
#define AAUTO_ADITNAVIGATIONSTATUS_H

#include <aauto/NavigationStatusEndpoint.h>
#include <aauto/MessageRouter.h>

namespace adit { namespace aauto {

/**
 * @brief callbacks to receive navigation status notifications from MD.
 * All callbacks have empty default implementations.
 * If necessary, need to be implemented . */
class IAditNavigationStatusCallbacks
{
public:
    virtual ~IAditNavigationStatusCallbacks(){ }

    virtual void navigationStatusCallback(int status) {
        (void) status;
        return;
    }

    virtual void navigationNextTurnCallback(const string& road, int turnSide, int event,
                                            const string& image, int turnAngle, int turnNumber) {
        (void) road;
        (void) turnSide;
        (void) event;
        (void) image;
        (void) turnAngle;
        (void) turnNumber;
        return;
    }

    virtual void navigationNextTurnDistanceCallback(int distanceMeters, int timeSeconds, int displayDistanceE3,
                                                    NavigationNextTurnDistanceEvent_DistanceUnits displayDistanceUnit) {
        (void) distanceMeters;
        (void) timeSeconds;
        (void) displayDistanceE3;
        (void) displayDistanceUnit;
        return;
    }
};

/** 
 * @brief AditNavigationStatus provides a base class for NavigationStatus implementations.
 * It aims to break dependency between ADIT-PF and GalReceiver.
 **/
class AditNavigationStatus : public NavigationStatusEndpoint
{
public:
/**
 * @brief  Constructor of AditNaviStatusSource.
 * @param  inSessionId      inSessionId is Id that is used in GalReceiver as identification data on session.
 * @param  inMessageRouter    inMessageRouter is message router obtained from GalReceiver.
 */
    AditNavigationStatus(uint8_t inSessionId, MessageRouter* inMessageRouter, int inMinIntervalMs, int inheight, int inWidth,
                         int inColorDepthBits, NavigationStatusService_InstrumentClusterType inType)
    : NavigationStatusEndpoint(inSessionId, inMessageRouter, inMinIntervalMs, inheight, inWidth, inColorDepthBits, inType) { }

    /**
     * @brief Set configuration for platform and AAuto-related items.
     *         All configurations must be called before init().
     * @param  inKey        The key string for configuration
     * @param  inValue      The actual value for configuration */
    virtual void setConfigItem(string inKey, string inValue) = 0;

    /**
     * @brief Register callbacks to receive navigation status notifications.
     * @param   inCallbacks object implementing the callback interface */
    virtual void registerCallbacks(IAditNavigationStatusCallbacks* inCallbacks) = 0;

    /**
     * @brief  Initialize the AditNavigationStatus library
     * @return true if initialization succeeds. Otherwise false. */
    virtual bool init() = 0;

    /**
     * @brief  Shut down the AditNavigationStatus library, stop running threads and release allocated resources
     */
    virtual void shutdown() = 0;

};

} } /* namespace adit { namespace aauto { */

#endif /* AAUTO_ADITNAVIGATIONSTATUS_H */
